/*
 * LinkedCell_Model_inline.hpp
 *
 *  Created on: Nov 18, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_MODEL_INLINE_HPP_
#define LINKEDCELL_MODEL_INLINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// have all includes only needed here extra
#ifdef HAVE_INLINE
#include "CodePatterns/Assert.hpp"
#endif

/** Returns a reference to the cell indicated by LinkedCell_Model::internal_index.
 *
 * \return LinkedCell ref to current cell
 */
#ifdef HAVE_INLINE
inline
#endif
const LinkedCell::LinkedCell& LinkedCell::LinkedCell_Model::getCell(const tripleIndex &index) const
{
  return *N(index);
}


/** Returns size of array for given \a dim.
 *
 * @param dim desired dimension
 * @return size of array along dimension
 */
#ifdef HAVE_INLINE
inline
#endif
LinkedCell::LinkedCellArray::index LinkedCell::LinkedCell_Model::getSize(const size_t dim) const
{
  ASSERT((dim >= 0) && (dim < NDIM),
      "LinkedCell_Model::getSize() - dimension "
      +toString(dim)+" is out of bounds.");
  return N.shape()[dim];
}


#endif /* LINKEDCELL_MODEL_INLINE_HPP_ */
