/*
 * LinkedCell_ModelUnitTest.hpp
 *
 *  Created on: Nov 17, 2011
 *      Author: heber
 */

#ifndef LINKEDCELL_MODELUNITTEST_HPP_
#define LINKEDCELL_MODELUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class Box;

namespace LinkedCell {
  class LinkedCell_Model;
}

#include <cppunit/extensions/HelperMacros.h>

/********************************************** Test classes **************************************/

class LinkedCell_ModelTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( LinkedCell_ModelTest) ;
    CPPUNIT_TEST ( AllocationTest );
    CPPUNIT_TEST ( getSizeTest );
    CPPUNIT_TEST ( ResetTest );
    CPPUNIT_TEST ( insertPointCloudTest );
    CPPUNIT_TEST ( setPartitionTest );
    CPPUNIT_TEST ( getStepTest );
    CPPUNIT_TEST ( getIndexToVectorTest );
    CPPUNIT_TEST ( nodeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();

      void AllocationTest();
      void getSizeTest();
      void ResetTest();
      void insertPointCloudTest();
      void setPartitionTest();
      void getStepTest();
      void getIndexToVectorTest();
      void nodeTest();

private:
      typedef std::set<TesselPoint *> PointSet;
      PointSet NodeList;

      Box *domain;
      LinkedCell::LinkedCell_Model *LC;
};


#endif /* LINKEDCELL_MODELUNITTEST_HPP_ */
