/*
 * MolecularVolumeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/MolecularVolumeAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "molecule.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/ValueStorage.hpp"

const char AnalysisMolecularVolumeAction::NAME[] = "molecular-volume";

AnalysisMolecularVolumeAction::AnalysisMolecularVolumeAction() :
  Action(NAME)
{}

AnalysisMolecularVolumeAction::~AnalysisMolecularVolumeAction()
{}

void AnalysisMolecularVolume() {
  ActionRegistry::getInstance().getActionByName(AnalysisMolecularVolumeAction::NAME)->call(Action::NonInteractive);
};

Dialog * AnalysisMolecularVolumeAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryEmpty(NAME, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr AnalysisMolecularVolumeAction::performCall() {
  int molID = -1;
  // obtain information
  ValueStorage::getInstance().queryCurrentValue(NAME, molID);

  // execute action
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    molecule *mol = iter->second;
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating volume of the convex envelope.");
    LCList = new LinkedCell(mol, 10.);
    config * const configuration = World::getInstance().getConfig();
    //FindConvexBorder(mol, BoundaryPoints, TesselStruct, LCList, argv[argptr]);
    FindNonConvexBorder(mol, TesselStruct, LCList, 5., NULL);
    //RemoveAllBoundaryPoints(TesselStruct, mol, argv[argptr]);
    double volumedifference = ConvexizeNonconvexEnvelope(TesselStruct, mol, NULL);
    double clustervolume = VolumeOfConvexEnvelope(TesselStruct, configuration);
    DoLog(0) && (Log() << Verbose(0) << "The tesselated volume area is " << clustervolume << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    DoLog(0) && (Log() << Verbose(0) << "The non-convex tesselated volume area is " << clustervolume-volumedifference << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    delete(TesselStruct);
    delete(LCList);
  }
  return Action::success;
}

Action::state_ptr AnalysisMolecularVolumeAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisMolecularVolumeAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisMolecularVolumeAction::canUndo() {
  return true;
}

bool AnalysisMolecularVolumeAction::shouldUndo() {
  return true;
}

const string AnalysisMolecularVolumeAction::getName() {
  return NAME;
}
