/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VerletIntegrationAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "AtomSet.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Dynamics/VerletForceIntegration.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <vector>
#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"

// and construct the stuff
#include "VerletIntegrationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeVerletIntegrationAction::performCall() {
  // obtain information
  getParametersfromValueStorage();


  DoLog(1) && (Log() << Verbose(1) << "Parsing forces file and Verlet integrating." << endl);
  // TODO: sollte besser stream nutzen, nicht filename direkt (es sei denn, ist prefix), besser fuer unit test
  char outputname[MAXSTRINGSIZE];
  strcpy(outputname, params.forcesfile.string().c_str());
  AtomSetMixin<std::vector<atom *> > set(World::getInstance().getSelectedAtoms());
  for (int step = 0; step < params.MDSteps; ++step) {
    VerletForceIntegration<std::vector<atom *> > Verlet(set, params.Deltat, step, false);
    if (!Verlet(outputname, 1, 0, params.FixedCenterOfMass))
      DoLog(2) && (Log() << Verbose(2) << "File " << params.forcesfile << " not found." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "File " << params.forcesfile << " found and parsed." << endl);
  }

  return Action::success;
}

Action::state_ptr MoleculeVerletIntegrationAction::performUndo(Action::state_ptr _state) {
//  MoleculeVerletIntegrationState *state = assert_cast<MoleculeVerletIntegrationState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeVerletIntegrationAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool MoleculeVerletIntegrationAction::canUndo() {
  return true;
}

bool MoleculeVerletIntegrationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
