/*
 * ActionExceptions.hpp
 *
 *  Created on: Sep 21, 2011
 *      Author: heber
 */

#ifndef ACTIONEXCEPTIONS_HPP_
#define ACTIONEXCEPTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <exception>
#include <boost/exception.hpp>

/** ============================= Begin of Exceptions ===================== */

/** Base class for all exceptions regarding Actions.
 *
 */
struct ActionException : virtual std::exception, virtual boost::exception { };

/** Exception information for ActionException: string.
 */
typedef boost::error_info<struct tag_ActionName, const std::string> ActionNameString;

/** Exception thrown when an Action fails.
 */
struct ActionFailureException : virtual ActionException { };

/** ============================== end of Exceptions ====================== */

#endif /* ACTIONEXCEPTIONS_HPP_ */
