/*
 * RemoveAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/AtomAction/RemoveAction.hpp"
#include "atom.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AtomRemoveAction::NAME[] = "remove-atom";

AtomRemoveAction::AtomRemoveAction() :
  Action(NAME)
{}

AtomRemoveAction::~AtomRemoveAction()
{}

Action::state_ptr AtomRemoveAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  atom *first = NULL;

  dialog->queryAtom(NAME, &first, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    delete dialog;
    DoLog(1) && (Log() << Verbose(1) << "Removing atom " << first->getId() << "." << endl);
    // TODO: this is not necessary when atoms and their storing to file are handled by the World
    // simply try to erase in every molecule found
    std::vector<molecule *> molecules = World::getInstance().getAllMolecules();
    for (std::vector<molecule *>::iterator iter = molecules.begin();iter != molecules.end(); ++iter) {
      (*iter)->erase(first);
    }
    World::getInstance().destroyAtom(first);
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }

}

Action::state_ptr AtomRemoveAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomRemoveAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomRemoveAction::canUndo() {
  return false;
}

bool AtomRemoveAction::shouldUndo() {
  return false;
}

const string AtomRemoveAction::getName() {
  return NAME;
}
