/*
 * atom_particleinfo.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#include "atom_particleinfo.hpp"
#include "memoryallocator.hpp"

/** Constructor of ParticleInfo.
 */
ParticleInfo::ParticleInfo() : nr(-1), Name(NULL) {};

/** Destructor of ParticleInfo.
 */
ParticleInfo::~ParticleInfo()
{
  Free(&Name);
};

int ParticleInfo::getId() {
  return nr;
}

ostream & operator << (ostream &ost, const ParticleInfo &a)
{
  ost << "[" << a.Name << "|" << &a << "]";
  return ost;
};

ostream & ParticleInfo::operator << (ostream &ost) const
{
  ost << "[" << Name << "|" << this << "]";
  return ost;
};

