/*
 * TextMenu.h
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#ifndef TEXTMENU_H_
#define TEXTMENU_H_

#include <list>
#include <ostream>
#include <string>

#include "Menu/Menu.hpp"

class MenuItem;

class TextMenu : public Menu
{
public:
  TextMenu(ostream&,string);
  virtual ~TextMenu();

  virtual void addItem(MenuItem*);
  virtual void removeItem(MenuItem*);
  virtual void display();

  virtual void doQuit();
  virtual bool hasQuit();

protected:
  virtual void showEntry(MenuItem*);

private:
  list<MenuItem*> items;
  ostream& outputter;
  string title;
  bool quit;
};

#endif /* TEXTMENU_H_ */
