/*
 * TextMenu.cpp
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#include <boost/bind.hpp>
#include <iostream>
#include "TextMenu.hpp"
#include "MenuItem.hpp"

TextMenu::TextMenu(ostream& _outputter, string _title) :
outputter(_outputter),
title(_title),
quit(false)
{
}

TextMenu::~TextMenu()
{
  // TODO Auto-generated destructor stub
}


void TextMenu::addItem(MenuItem* item) {
  items.push_back(item);
}

void TextMenu::removeItem(MenuItem* item) {
  items.remove(item);
}

void TextMenu::doQuit(){
  quit = true;
}

bool TextMenu::hasQuit(){
  return quit;
}

void TextMenu::showEntry(MenuItem* entry){
  outputter << entry->formatEntry() << "\n";
}

void TextMenu::display() {
  char choice;
  do {
    outputter << title << "\n";
    for_each(items.begin(), items.end(), boost::bind(&TextMenu::showEntry,this,_1));
    outputter.flush();

    cin >> choice;

    for_each(items.begin(), items.end(), boost::bind(&MenuItem::checkTrigger,_1,choice));
  }while (!hasQuit());
}
