/*
 * MenuItem.cpp
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */



#include "Menu/MenuItem.hpp"
#include "Menu/Menu.hpp"
#include <sstream>

MenuItem::MenuItem(char _trigger, const char* _description,Menu* menu) :
trigger(_trigger)
{
  description = new string(_description);
  menu->addItem(this);
}

MenuItem::~MenuItem()
{
  delete description;
}

void MenuItem::checkTrigger(char key) {
  if(key == trigger)
    doTrigger();
}

char MenuItem::getTrigger() {
  return trigger;
}

const string MenuItem::getDescription() {
  return *description;
}

const string MenuItem::formatEntry(){
  stringstream s;
  s << getTrigger() << " - " << getDescription();

  return s.str();
}
