/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RegistryUnitTest.cpp
 *
 *  Created on: Oct 27, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <typeinfo>

#include "stubs/CommonNamedStub.hpp"
#include "stubs/RegistryStub.hpp"

#include "Assert.hpp"

#include "RegistryUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( RegistryTest );


void RegistryTest::setUp()
{
  ASSERT_DO(Assert::Throw);
  registry = new RegistryStub;
};


void RegistryTest::tearDown()
{
  delete registry;
};

void RegistryTest::InOutCheck()
{
  // create two test instances to put into the registry
  teststubs::ANamedclass *instanceA = new teststubs::ANamedclass;
  teststubs::BNamedclass *instanceB = new teststubs::BNamedclass;
  teststubs::INamedclass *testinstance = NULL;

  // register both instances
  registry->registerInstance(instanceA);
  registry->registerInstance(instanceB);

  // obtain Aclass and see if it matches
  testinstance = registry->getByName("ANamedclass");
  CPPUNIT_ASSERT( testinstance == instanceA );

  // unregister Aclass and see if there's no more match
  registry->unregisterInstance(instanceA);
  testinstance = NULL;
#ifndef NDEBUG
  CPPUNIT_ASSERT_THROW((testinstance = registry->getByName("ANamedclass")),Assert::AssertionFailure);
#else
  testinstance = registry->getByName("ANamedclass");
#endif
  CPPUNIT_ASSERT( testinstance == NULL );

  // obtain Bclass and see if it matches
  testinstance = registry->getByName("BNamedclass");
  CPPUNIT_ASSERT( testinstance == instanceB );

  // unregister Aclass and see if there's no more match
  registry->unregisterInstance(instanceB);
  testinstance = NULL;
#ifndef NDEBUG
  CPPUNIT_ASSERT_THROW((testinstance = registry->getByName("BNamedclass")),Assert::AssertionFailure);
#else
  testinstance = registry->getByName("BNamedclass");
#endif
  CPPUNIT_ASSERT( testinstance == NULL );
  CPPUNIT_ASSERT( testinstance == NULL );

  // check that registry is empty
  CPPUNIT_ASSERT( registry->getBeginIter() == registry->getEndIter() );

  delete instanceA;
  delete instanceB;
}
