import pyMoleCuilder as mol
import re, os, sys

cmds =  filter(lambda s: (s[0] != '_') and (s[0:11] != "PythonType_"), dir(mol))

# read options.dat

Defaults = {}

with open('options.dat') as f:
    for line in f:
        if len(line) > 0 and line[0] != '#':
            try:
              key, value = line.split('\t', 1)
            except ValueError:
              print("line needs two values, tab-separated: "+line)
              sys.exit(1)
            value = value[1:-2] # remove quotes
        
            Defaults[key] = value

Allparams = []

def CheckParameters(docstring):
    result = 0
    params = re.findall(r'\(str\)([-_a-zA-Z0-9]*)', docstring)

    for param in params:
        if not param in Allparams:
            Allparams.append(param)
            
            if not param in Defaults:
                print(param, file=sys.stderr) # write missing default value to stderr
                result = 1

    return result

result = 0

for cmd in cmds:
    print("Checking on %s" % cmd)
    doc = eval('mol.%s.__doc__' % cmd)
    if CheckParameters(doc) == 1:
        result = 1
        
sys.exit(result)
