/*
 * Parameter.hpp
 *
 *  Created on: Apr 16, 2012
 *      Author: ankele
 */

#ifndef PARAMETER_HPP_
#define PARAMETER_HPP_



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Value.hpp"
#include "ValueInterface.hpp"
#include "ParameterInterface.hpp"

class ParameterException;
class ParameterValueException;

/** This class encapsulates a clonable, continuous value.
 *
 */
template <typename T>
class Parameter :
  public ParameterInterface,
  public ValueInterface<T>
{
public:
  Parameter(const Parameter<T> &instance);
  Parameter(const std::string &_name);
  Parameter(const std::string &_name, const T &_value);
  Parameter(const std::string &_name, const Validator<T> &_Validator);
  Parameter(const std::string &_name, const Validator<T> &_Validator, const T &_value);
  Parameter(const std::string &_name, const std::vector<T> &_ValidValues);
  Parameter(const std::string &_name, const std::vector<T> &_ValidValues, const T &_value);
  Parameter(const std::string &_name, const range<T> &_ValidRange);
  Parameter(const std::string &_name, const range<T> &_ValidRange, const T &_value);
  virtual ~Parameter();

  // wrap the following functions from ValueAsString to add exception information
  bool isValidAsString(const std::string &_value) const throw(ParameterValidatorException);
  const std::string getAsString() const throw(ParameterValueException);
  void setAsString(const std::string &_value) throw(ParameterValueException);

  // wrap the following functions from Value<T> to add exception information
  bool isValid(const T &_value) const throw(ParameterValidatorException);
  const T & get() const throw(ParameterValueException);
  void set(const T & _value) throw(ParameterValueException);
  bool isSet() const
  { return value.isSet(); }

  const Validator<T> & getValidator() const
  { return value.getValidator(); }
  Validator<T> & getValidator()
  { return value.getValidator(); }

  // comparator
  bool operator==(const Parameter<T> &_instance) const throw(ParameterException);
  bool operator!=(const Parameter<T> &_instance) const throw(ParameterException)
      { return !((*this)==(_instance)); }

  ParameterInterface* clone() const;

//private: // TODO...
  Parameter();

private:
  //!> contained value of this parameter
  Value<T> value;
};

#include "Parameter_impl.hpp"


#endif /* PARAMETER_HPP_ */
