/*
 * TextWindow.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#include "UIElements/TextWindow.hpp"

#include <boost/bind.hpp>


// TODO: When done with refactoring most of these wont be needed anymore
#include "analysis_correlation.hpp"
#include "atom.hpp"
#include "bond.hpp"
#include "bondgraph.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "element.hpp"
#include "ellipsoid.hpp"
#include "helpers.hpp"
#include "leastsquaremin.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "memoryusageobserverunittest.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"

#include "Legacy/oldmenu.hpp"

#include "Menu/Menu.hpp"
#include "Menu/TextMenu.hpp"
#include "Menu/ActionMenuItem.hpp"
#include "Menu/SeperatorItem.hpp"
#include "Menu/DisplayMenuItem.hpp"
#include "Menu/SubMenuItem.hpp"
#include "UIElements/TextStatusIndicator.hpp"
#include "Actions/MethodAction.hpp"
#include "Actions/ErrorAction.hpp"
#include "Views/StreamStringView.hpp"
#include "Views/MethodStringView.hpp"

#include <iostream>

using namespace std;

// TODO: see what code can be moved to a base class for Graphic and Text Windows
TextWindow::TextWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration, periodentafel *periode, char *ConfigFileName)
{
  old_menu = new oldmenu;

  // build the main menu
  main_menu = new TextMenu(Log() << Verbose(0), "Main Menu");

  moleculeView = new StreamStringView(boost::bind(&MoleculeListClass::Enumerate,molecules,_1));
  new DisplayMenuItem(main_menu,moleculeView,"Molecule List");

  new SeperatorItem(main_menu);

  Action *setMoleculeAction = new MethodAction("setMoleculeAction",boost::bind(&MoleculeListClass::flipChosen,molecules));
  new ActionMenuItem('a',"set molecule (in)active",main_menu,setMoleculeAction);

  TextMenu *editMoleculesMenu = new TextMenu(Log() << Verbose(0), "Edit Molecules");
  new SubMenuItem('e',"edit molecules (load, parse, save)",main_menu,editMoleculesMenu);

  Action *manipulateMoleculeAction = new MethodAction("manipulateMoleculeAction",boost::bind(&oldmenu::ManipulateMolecules,old_menu,periode, molecules, configuration));
  new ActionMenuItem('g',"globally manipulate atoms in molecule",main_menu,manipulateMoleculeAction);

  Action *mergeMoleculeAction = new MethodAction("mergeMoleculeAction",boost::bind(&oldmenu::MergeMolecules,old_menu,periode, molecules));
  new ActionMenuItem('M',"Merge molecules",main_menu,mergeMoleculeAction);

  Action *manipulateAtomsAction = new MethodAction("manipulateAtomsAction",boost::bind(&oldmenu::ManipulateAtoms,old_menu,periode, molecules, configuration));
  new ActionMenuItem('m',"manipulate atoms",main_menu,manipulateAtomsAction);

  new SeperatorItem(main_menu);

  Action *editConfigAction = new MethodAction("editConfigAction",boost::bind(&config::Edit,configuration));
  new ActionMenuItem('c',"edit the current configuration",main_menu,editConfigAction);

  new SeperatorItem(main_menu);

  Action *saveConfigAction = new MethodAction("saveConfigAction",boost::bind(&config::SaveAll,configuration, ConfigFileName, periode, molecules));
  new ActionMenuItem('s',"save current setup to config file",main_menu,saveConfigAction);

  Action *doTestAction = new MethodAction("doTestAction",boost::bind(&oldmenu::testroutine,old_menu,molecules));
  new ActionMenuItem('T',"call the current test routine",main_menu,doTestAction);

  quitAction = new MethodAction("quitAction",boost::bind(&TextMenu::doQuit,main_menu),false);
  new ActionMenuItem('q',"quit",main_menu,quitAction);

  // call all functions used to build the submenus

  populaters.MakeEditMoleculesMenu(editMoleculesMenu,molecules,configuration,periode);

  returnFromEditMoleculeAction = new MethodAction("returnAction",boost::bind(&TextMenu::doQuit,editMoleculesMenu),false);
  MenuItem *returnItem = new ActionMenuItem('q',"return to Main menu",editMoleculesMenu,returnFromEditMoleculeAction);

  editMoleculesMenu->addDefault(returnItem);

  // Add status indicators etc...

  statusIndicator = new TextStatusIndicator();
}

TextWindow::~TextWindow()
{
  delete old_menu;
  delete quitAction;
  delete returnFromEditMoleculeAction;
  delete moleculeView;
  delete statusIndicator;
  delete main_menu;
}

void TextWindow::display() {
  main_menu->display();
}
