#ifndef VECTOR_HPP_
#define VECTOR_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_multimin.h>

#include <memory>

#include "defs.hpp"

/********************************************** declarations *******************************/

/** Single vector.
 * basically, just a x[3] but with helpful functions
 */
class Vector {
protected:
  // this struct is used to indicate calls to the Baseconstructor from inside vectors.
  struct Baseconstructor{};
public:

  Vector();
  Vector(const double x1, const double x2, const double x3);
  Vector(const Vector& src);
  virtual ~Vector();

  // Method implemented by forwarding to the Representation

  double DistanceSquared(const Vector &y) const;
  Vector GetDistanceVectorToPlane(const Vector &PlaneNormal, const Vector &PlaneOffset) const;
  double DistanceToPlane(const Vector &PlaneNormal, const Vector &PlaneOffset) const;
  double PeriodicDistance(const Vector &y, const double * const cell_size) const;
  double PeriodicDistanceSquared(const Vector &y, const double * const cell_size) const;
  double ScalarProduct(const Vector &y) const;
  double Angle(const Vector &y) const;
  bool IsZero() const;
  bool IsOne() const;
  bool IsNormalTo(const Vector &normal) const;
  bool IsEqualTo(const Vector &a) const;

  void AddVector(const Vector &y);
  void SubtractVector(const Vector &y);
  void VectorProduct(const Vector &y);
  void ProjectOntoPlane(const Vector &y);
  void ProjectIt(const Vector &y);
  Vector Projection(const Vector &y) const;
  void Mirror(const Vector &x);
  void ScaleAll(const double *factor);
  void Scale(const double factor);
  void MatrixMultiplication(const double * const M);
  bool InverseMatrixMultiplication(const double * const M);
  void KeepPeriodic(const double * const matrix);
  bool GetOneNormalVector(const Vector &x1);
  bool MakeNormalTo(const Vector &y1);
  bool IsInParallelepiped(const Vector &offset, const double * const parallelepiped) const;
  void WrapPeriodically(const double * const M, const double * const Minv);

  // Accessors ussually come in pairs... and sometimes even more than that
  double& operator[](size_t i);
  const double& operator[](size_t i) const;
  double& at(size_t i);
  const double& at(size_t i) const;

  // Assignment operator
  Vector &operator=(const Vector& src);

  // Access to internal structure
  double* get();

  // Methods that are derived directly from other methods
  double Distance(const Vector &y) const;
  double Norm() const;
  double NormSquared() const;
  void Normalize();
  void Zero();
  void One(const double one);
  void LinearCombinationOfVectors(const Vector &x1, const Vector &x2, const Vector &x3, const double * const factors);

  // operators for mathematical operations
  bool operator==(const Vector& b) const;
  const Vector& operator+=(const Vector& b);
  const Vector& operator-=(const Vector& b);
  Vector const operator+(const Vector& b) const;
  Vector const operator-(const Vector& b) const;

protected:

private:
  double x[NDIM];

};

ostream & operator << (ostream& ost, const Vector &m);
const Vector& operator*=(Vector& a, const double m);
Vector const operator*(const Vector& a, const double m);
Vector const operator*(const double m, const Vector& a);

#endif /*VECTOR_HPP_*/
