/*
 * ActOnAlltest.hpp
 *
 *  Created on: 04.10.2009
 *      Author: FrederikHeber
 */

#ifndef ACTONALLTEST_HPP_
#define ACTONALLTEST_HPP_

using namespace std;

#include <list>
#include "../vector.hpp"

#define ListOfVectors list<Vector *>

class VectorList
{
public:
  VectorList();
  VectorList(VectorList &ref);
  ~VectorList();

  void AddVector(Vector *v);
  void EmptyList();

  template <typename klasse, typename res, typename T> void ActOnAll( res (klasse::*f)(T), T t );
  template <typename klasse, typename res, typename T> void ActOnAll( res (klasse::*f)(T&), T &t );
  template <typename klasse, typename res, typename T, typename U> void ActOnAll( res (klasse::*f)(T, U), T t, U u );
  template <typename klasse, typename res, typename T, typename U, typename V> void ActOnAll( res (klasse::*f)(T, U, V), T t, U u, V v);

  bool operator == (VectorList &rhs);
  VectorList& operator = (VectorList &ref);

//private:
  ListOfVectors Vectors;
};


VectorList::VectorList() { };
VectorList::VectorList(VectorList &ref)
{
  ref.EmptyList();
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++) {
    ref.Vectors.push_back(new Vector (**Runner));
  }
};

VectorList & VectorList::operator = (VectorList &ref)
{
  EmptyList();
  for (ListOfVectors::iterator Runner = ref.Vectors.begin(); Runner != ref.Vectors.end(); Runner++) {
    Vectors.push_back(new Vector (**Runner));
  }
  return *this;
};

bool VectorList::operator == (VectorList &rhs)
{
  bool status = true;
  ListOfVectors::iterator lRunner = Vectors.begin();
  ListOfVectors::iterator rRunner = rhs.Vectors.begin();
  for (;(lRunner != Vectors.end()) && (rRunner != rhs.Vectors.end()); lRunner++, rRunner++) {
    //Log() << Verbose(0) << **lRunner << " == " << **rRunner << endl;
    status = status && (**lRunner == **rRunner);
  }
  return status;
};

VectorList::~VectorList() { };

template <typename klasse, typename res, typename T> void VectorList::ActOnAll( res (klasse::*f)(T), T t )
{
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++)
    ((*Runner)->*f)(t);
};

template <typename klasse, typename res, typename T> void VectorList::ActOnAll( res (klasse::*f)(T&), T &t )
{
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++)
    ((*Runner)->*f)(t);
};

template <typename klasse, typename res, typename T, typename U> void VectorList::ActOnAll( res (klasse::*f)(T, U), T t, U u )
{
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++)
    ((*Runner)->*f)(t, u);
};

template <typename klasse, typename res, typename T, typename U, typename V> void VectorList::ActOnAll( res (klasse::*f)(T, U, V), T t, U u, V v)
{
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++)
    ((*Runner)->*f)(t, u, v);
};

void VectorList::AddVector(Vector *v)
{
  Vectors.push_back(v);
};

void VectorList::EmptyList()
{
  for (ListOfVectors::iterator Runner = Vectors.begin(); Runner != Vectors.end(); Runner++) {
    delete(*Runner);
  }
  Vectors.clear();
}

#endif /* ACTONALLTEST_HPP_ */
