/*
 * Plane.hpp
 *
 *  Created on: Apr 7, 2010
 *      Author: crueger
 */

#ifndef PLANE_HPP_
#define PLANE_HPP_

#include <memory>
#include <vector>

class Vector;

class Plane
{
  typedef std::auto_ptr<Vector> vec_ptr;
public:
  Plane(const Vector &y1, const Vector &y2, const Vector &y3);
  Plane(const Vector &y1, const Vector &y2, double _offset);
  Plane(const Vector &_normalVector, double _offset=0);
  Plane(const Vector &_normalVector, const Vector &_offsetVector);
  virtual ~Plane();

  // Accessor Functions
  /**
   * returns normal Vector for a plane
   */
  Vector getNormal();
  /**
   * returns the distance of the plane from the origin
   */
  double getOffset();
  /**
   * returns a vector that points on the plane.
   * Same as getOffset()*getNormal();
   */
  Vector getOffsetVector();

  /**
   * returns three seperate points on this plane
   */
  std::vector<Vector> getPointsOnPlane();

  // some calculations
  Vector GetIntersection(const Vector &Origin, const Vector &LineVector);

private:
  vec_ptr normalVector;
  double offset;
};

#endif /* PLANE_HPP_ */
