/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Tesselation_InsideOutsideUnitTest.cpp
 *
 *  Created on: Dec 28, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>
#include <iostream>

#include "Atom/TesselPoint.hpp"
#include "CodePatterns/Log.hpp"
#include "Helpers/defs.hpp"
#include "LinkedCell/PointCloudAdaptor.hpp"
#include "Tesselation/BoundaryLineSet.hpp"
#include "Tesselation/BoundaryTriangleSet.hpp"
#include "Tesselation/CandidateForTesselation.hpp"
#include "Tesselation/tesselation.hpp"

#include "Tesselation_InsideOutsideUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

const double TesselationInOutsideTest::SPHERERADIUS=2.;

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( TesselationInOutsideTest );

void TesselationInOutsideTest::setUp()
{
  setVerbosity(2);

  // create corners
  class TesselPoint *Walker;
  Walker = new TesselPoint;
  Walker->setPosition(Vector(0., 0., 0.));
  Walker->setName("1");
  Walker->setNr(1);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(0., 1., 0.));
  Walker->setName("2");
  Walker->setNr(2);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(1., 0., 0.));
  Walker->setName("3");
  Walker->setNr(3);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(1., 1., 0.));
  Walker->setName("4");
  Walker->setNr(4);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(0., 0., 1.));
  Walker->setName("5");
  Walker->setNr(5);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(0., 1., 1.));
  Walker->setName("6");
  Walker->setNr(6);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(1., 0., 1.));
  Walker->setName("7");
  Walker->setNr(7);
  Corners.push_back(Walker);
  Walker = new TesselPoint;
  Walker->setPosition(Vector(1., 1., 1.));
  Walker->setName("8");
  Walker->setNr(8);
  Corners.push_back(Walker);

  // create LinkedCell
  PointCloudAdaptor< TesselPointSTLList > cloud(&Corners, "TesselPointSTLList");
  LinkedList = new LinkedCell_deprecated(cloud, 2.*SPHERERADIUS);

  // create tesselation
  TesselStruct = new Tesselation;
  (*TesselStruct)(cloud, SPHERERADIUS);
};


void TesselationInOutsideTest::tearDown()
{
	delete LinkedList;
  delete TesselStruct;
  for (TesselPointSTLList::iterator Runner = Corners.begin(); Runner != Corners.end(); Runner++)
    delete *Runner;
  Corners.clear();
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationInOutsideTest::IsInnerPointTest()
{
  double n[3];
  const double boundary = 2.;
  const double step = 1.;

  // go through the mesh and check each point
  for (n[0] = -boundary; n[0] <= boundary; n[0]+=step)
    for (n[1] = -boundary; n[1] <= boundary; n[1]+=step)
      for (n[2] = -boundary; n[2] <= boundary; n[2]+=step) {
        if ( ((n[0] >= 0.) && (n[1] >= 0.) && (n[2] >= 0.)) && ((n[0] <= 1.) && (n[1] <= 1.) && (n[2] <= 1.)))
          CPPUNIT_ASSERT_EQUAL( true , TesselStruct->IsInnerPoint(Vector(n[0], n[1], n[2]), LinkedList) );
        else
          CPPUNIT_ASSERT_EQUAL( false , TesselStruct->IsInnerPoint(Vector(n[0], n[1], n[2]), LinkedList) );
      }
};
