/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MPQCJob.cpp
 *
 *  Created on: Jul 10, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "MPQCJob.hpp"

#include <limits>

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"


MPQCJob::MPQCJob(
    const JobId_t _JobId,
    const std::string &_inputfile,
    const double _begin[NDIM],
    const double _end[NDIM],
    const int _level) :
  FragmentJob(_JobId),
  DoLongrange(MPQCData::DontSampleDensity),
  DoValenceOnly(MPQCData::DoSampleValenceOnly),
  inputfile(_inputfile),
  grid(_begin, _end, _level)
{
#ifndef NDEBUG
  const double length[NDIM] = {
      _end[0] - _begin[0],
      _end[1] - _begin[1],
      _end[2] - _begin[2]
  };
  ASSERT( (fabs(length[0] - length[1]) < std::numeric_limits<double>::epsilon()*1e4)
      && (fabs(length[0] - length[2]) < std::numeric_limits<double>::epsilon()*1e4) ,
      "MPQCJob::MPQCJob() - box needs to be cubic.");
#endif
}

MPQCJob::MPQCJob() :
  FragmentJob(JobId::IllegalJob),
  DoLongrange(MPQCData::DontSampleDensity),
  DoValenceOnly(MPQCData::DoSampleValenceOnly)
{}

MPQCJob::~MPQCJob()
{}

// we need to explicitly instantiate the serialization functions as
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_IMPLEMENT(MPQCJob)
