/*
 * Matrix.hpp
 *
 *  Created on: Jun 25, 2010
 *      Author: crueger
 */

#ifndef MATRIX_HPP_
#define MATRIX_HPP_

#include <gsl/gsl_matrix.h>
#include "defs.hpp"

class Vector;

class Matrix
{
  friend Vector operator*(const Matrix&,const Vector&);
public:
  Matrix();
  Matrix(const double*);
  Matrix(const Matrix&);
  virtual ~Matrix();

  double &at(size_t i, size_t j);
  const double &at(size_t i, size_t j) const;

  double determinant() const;

  Matrix invert() const;

  // operators
  Matrix &operator=(const Matrix&);

  Matrix &operator+=(const Matrix&);
  Matrix &operator-=(const Matrix&);
  Matrix &operator*=(const Matrix&);

  Matrix &operator*=(const double);

  Matrix operator+(const Matrix&) const;
  Matrix operator-(const Matrix&) const;
  Matrix operator*(const Matrix&) const;

private:
  Matrix(gsl_matrix*);
  gsl_matrix *content;
};

Matrix operator*(const double,const Matrix&);
Matrix operator*(const Matrix&,const double);

Matrix ReturnFullMatrixforSymmetric(const double * const cell_size);

#endif /* MATRIX_HPP_ */
