/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DipoleAngularCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "CodePatterns/Verbose.hpp"
#include "CodePatterns/Log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/AnalysisAction/DipoleAngularCorrelationAction.hpp"

// and construct the stuff
#include "DipoleAngularCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisDipoleAngularCorrelationAction::performCall() {
  //int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.string().c_str());
  binoutput.open(params.binoutputname.string().c_str());
  DipoleAngularCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  DoLog(0) && (Log() << Verbose(0) << "There are " << molecules.size() << " selected molecules." << std::endl);
  ASSERT(!params.periodic, "AnalysisDipoleAngularCorrelationAction() - periodic case not implemented.");
  correlationmap = DipoleAngularCorrelation(molecules);
  OutputDipoleAngularCorrelation(&output, correlationmap);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisDipoleAngularCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisDipoleAngularCorrelationAction::canUndo() {
  return true;
}

bool AnalysisDipoleAngularCorrelationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
