/*
 * SurfaceCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/SurfaceCorrelationAction.hpp"
#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "verbose.hpp"
#include "log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisSurfaceCorrelationAction::NAME[] = "surface-correlation";

AnalysisSurfaceCorrelationAction::AnalysisSurfaceCorrelationAction() :
  Action(NAME)
{}

AnalysisSurfaceCorrelationAction::~AnalysisSurfaceCorrelationAction()
{}

Dialog* AnalysisSurfaceCorrelationAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule("molecule-by-id", MapOfActions::getInstance().getDescription("molecule-by-id"));
  dialog->queryElement("elements", MapOfActions::getInstance().getDescription("elements"));
  dialog->queryDouble("bin-start", MapOfActions::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-width", MapOfActions::getInstance().getDescription("bin-width"));
  dialog->queryDouble("bin-end", MapOfActions::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", MapOfActions::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", MapOfActions::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", MapOfActions::getInstance().getDescription("periodic"));

  return dialog;
}

Action::state_ptr AnalysisSurfaceCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  double BinEnd = 0.;
  double BinStart = 0.;
  double BinWidth = 0.;
  molecule *Boundary = NULL;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  std::vector< element *> elements;
  string type;
  Vector Point;
  BinPairMap *binmap = NULL;
  MoleculeListClass *molecules = World::getInstance().getMolecules();

  // obtain information
  MapOfActions::getInstance().queryCurrentValue("molecule-by-id", Boundary);
  MapOfActions::getInstance().queryCurrentValue("elements", elements);
  MapOfActions::getInstance().queryCurrentValue("bin-start", BinStart);
  MapOfActions::getInstance().queryCurrentValue("bin-width", BinWidth);
  MapOfActions::getInstance().queryCurrentValue("bin-end", BinEnd);
  MapOfActions::getInstance().queryCurrentValue("output-file", outputname);
  MapOfActions::getInstance().queryCurrentValue("bin-output-file", binoutputname);
  MapOfActions::getInstance().queryCurrentValue("periodic", periodic);

  // execute action
  output.open(outputname.c_str());
  binoutput.open(binoutputname.c_str());
  ASSERT(Boundary != NULL, "No molecule specified for SurfaceCorrelation.");
  const double radius = 4.;
  double LCWidth = 20.;
  if (BinEnd > 0) {
    if (BinEnd > 2.*radius)
      LCWidth = BinEnd;
    else
      LCWidth = 2.*radius;
  }

  // get the boundary
  class Tesselation *TesselStruct = NULL;
  const LinkedCell *LCList = NULL;
  // find biggest molecule
  int counter  = molecules->ListOfMolecules.size();
  bool *Actives = new bool[counter];
  counter = 0;
  for (MoleculeList::iterator BigFinder = molecules->ListOfMolecules.begin(); BigFinder != molecules->ListOfMolecules.end(); BigFinder++) {
    Actives[counter++] = (*BigFinder)->ActiveFlag;
    (*BigFinder)->ActiveFlag = (*BigFinder == Boundary) ? false : true;
  }
  LCList = new LinkedCell(Boundary, LCWidth);
  FindNonConvexBorder(Boundary, TesselStruct, LCList, radius, NULL);
  CorrelationToSurfaceMap *surfacemap = NULL;
  if (periodic)
    surfacemap = PeriodicCorrelationToSurface( molecules, elements, TesselStruct, LCList, ranges);
  else
    surfacemap = CorrelationToSurface( molecules, elements, TesselStruct, LCList);
  delete LCList;
  OutputCorrelationToSurface(&output, surfacemap);
  // re-set ActiveFlag
  counter = 0;
  for (MoleculeList::iterator BigFinder = molecules->ListOfMolecules.begin(); BigFinder != molecules->ListOfMolecules.end(); BigFinder++) {
    (*BigFinder)->ActiveFlag = Actives[counter++];
  }
  delete[] Actives;
  // check whether radius was appropriate
  {
    double start; double end;
    GetMinMax( surfacemap, start, end);
    if (LCWidth < end)
      DoeLog(1) && (eLog()<< Verbose(1) << "Linked Cell width is smaller than the found range of values! Bins can only be correct up to: " << radius << "." << endl);
  }
  binmap = BinData( surfacemap, BinWidth, BinStart, BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete TesselStruct;  // surfacemap contains refs to triangles! delete here, not earlier!
  delete(binmap);
  delete(surfacemap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisSurfaceCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisSurfaceCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisSurfaceCorrelationAction::canUndo() {
  return true;
}

bool AnalysisSurfaceCorrelationAction::shouldUndo() {
  return true;
}

const string AnalysisSurfaceCorrelationAction::getName() {
  return NAME;
}
