/*
 * PrincipalAxisSystemAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/PrincipalAxisSystemAction.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPrincipalAxisSystemAction::NAME[] = "principal-axis-system";

AnalysisPrincipalAxisSystemAction::AnalysisPrincipalAxisSystemAction() :
  Action(NAME)
{}

AnalysisPrincipalAxisSystemAction::~AnalysisPrincipalAxisSystemAction()
{}

Dialog* AnalysisPrincipalAxisSystemAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryMolecule(NAME, MapOfActions::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performCall() {
  molecule *mol = NULL;

  MapOfActions::getInstance().queryCurrentValue(NAME, mol);
  DoLog(0) && (Log() << Verbose(0) << "Evaluating prinicipal axis." << endl);
  mol->PrincipalAxisSystem(false);
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPrincipalAxisSystemAction::canUndo() {
  return true;
}

bool AnalysisPrincipalAxisSystemAction::shouldUndo() {
  return true;
}

const string AnalysisPrincipalAxisSystemAction::getName() {
  return NAME;
}
