/*
 * PointCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/PointCorrelationAction.hpp"
#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "verbose.hpp"
#include "log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisPointCorrelationAction::NAME[] = "point-correlation";

AnalysisPointCorrelationAction::AnalysisPointCorrelationAction() :
  Action(NAME)
{}

AnalysisPointCorrelationAction::~AnalysisPointCorrelationAction()
{}

Dialog* AnalysisPointCorrelationAction::createDialog() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryVector("position", false, MapOfActions::getInstance().getDescription("position"));
  dialog->queryElement("elements", MapOfActions::getInstance().getDescription("elements"));
  dialog->queryDouble("bin-start", MapOfActions::getInstance().getDescription("bin-start"));
  dialog->queryDouble("bin-width", MapOfActions::getInstance().getDescription("bin-width"));
  dialog->queryDouble("bin-end", MapOfActions::getInstance().getDescription("bin-end"));
  dialog->queryString("output-file", MapOfActions::getInstance().getDescription("output-file"));
  dialog->queryString("bin-output-file", MapOfActions::getInstance().getDescription("bin-output-file"));
  dialog->queryBoolean("periodic", MapOfActions::getInstance().getDescription("periodic"));

  return dialog;
}

Action::state_ptr AnalysisPointCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  double BinEnd = 0.;
  double BinStart = 0.;
  double BinWidth = 0.;
  molecule *Boundary = NULL;
  string outputname;
  string binoutputname;
  bool periodic;
  ofstream output;
  ofstream binoutput;
  std::vector< element *> elements;
  string type;
  Vector Point;
  BinPairMap *binmap = NULL;
  MoleculeListClass *molecules = World::getInstance().getMolecules();

  // obtain information
  MapOfActions::getInstance().queryCurrentValue("position", Point);
  MapOfActions::getInstance().queryCurrentValue("elements", elements);
  MapOfActions::getInstance().queryCurrentValue("bin-start", BinStart);
  MapOfActions::getInstance().queryCurrentValue("bin-width", BinWidth);
  MapOfActions::getInstance().queryCurrentValue("bin-end", BinEnd);
  MapOfActions::getInstance().queryCurrentValue("output-file", outputname);
  MapOfActions::getInstance().queryCurrentValue("bin-output-file", binoutputname);
  MapOfActions::getInstance().queryCurrentValue("periodic", periodic);

  // execute action
  output.open(outputname.c_str());
  binoutput.open(binoutputname.c_str());
  cout << "Point to correlate to is  " << Point << endl;
  CorrelationToPointMap *correlationmap = NULL;
  if (periodic)
    correlationmap  = PeriodicCorrelationToPoint(molecules, elements, &Point, ranges);
  else
    correlationmap = CorrelationToPoint(molecules, elements, &Point);
  OutputCorrelationToPoint(&output, correlationmap);
  binmap = BinData( correlationmap, BinWidth, BinStart, BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPointCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPointCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPointCorrelationAction::shouldUndo() {
  return true;
}

const string AnalysisPointCorrelationAction::getName() {
  return NAME;
}
