/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * SamplingGrid.cpp
 *
 *  Created on: 25.07.2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "CodePatterns/MemDebug.hpp"

#include "Jobs/Grid/SamplingGridProperties.hpp"

SamplingGridProperties::SamplingGridProperties(
    const double _begin[3],
    const double _size,
    const int _level) :
  size(_size),
  level(_level)
{
  for(size_t i=0; i<3; ++i)
    begin[i] = _begin[i];
}

SamplingGridProperties::SamplingGridProperties(const SamplingGridProperties &_props) :
  size(_props.size),
  level(_props.level)
{
  for(size_t i=0; i<3; ++i)
    begin[i] = _props.begin[i];
}

SamplingGridProperties::SamplingGridProperties() :
  size(0.),
  level(0)
{
  for(size_t i=0; i<3; ++i)
    begin[i] = 0.;
}

SamplingGridProperties::~SamplingGridProperties()
{}

bool SamplingGridProperties::operator==(const SamplingGridProperties &_props) const
{
  bool status = true;
  for (size_t i=0; i<3; ++i)
    status &= begin[i] == _props.begin[i];
  status &= size == _props.size;
  status &= level == _props.level;
  return status;
}

// we need to explicitly instantiate the serialization functions as
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_IMPLEMENT(SamplingGridProperties)
