/*
 * CommandLineParser.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include <boost/program_options.hpp>
#include <fstream>
#include <iostream>

#include "Patterns/Singleton_impl.hpp"
#include "CommandLineParser.hpp"

using namespace std;

/** Constructor of class CommandLineParser.
 *
 */
CommandLineParser::CommandLineParser() :
  generic("Generic options"),
  config("Configuration"),
  hidden("Hidden options"),
  visible("Allowed options")
{}

/** Destructor of class CommandLineParser.
 *
 */
CommandLineParser::~CommandLineParser()
{}

/** Parses the command line arguments.
 * Calls program_options::store() and program_options::notify()
 */
void CommandLineParser::Parse()
{
  po::store(po::command_line_parser(argc,argv).options(cmdline_options).run(), vm);
  po::store(po::command_line_parser(argc,argv).options(visible).run(), vm);
  ifstream input;
  input.open("example.cfg");
  if (!input.fail())
    po::store(po::parse_config_file(input, config_file_options), vm);
  input.close();
  po::notify(vm);
}

/** States whether there are command line arguments.
 * \return true - there are none, false - there is at least one command line argument
 */
bool CommandLineParser::isEmpty()
{
  return vm.empty();
}

/** Sets the options.
 * \param _argc arg count from main()
 * \param **_argv argument array from main()
 */
void CommandLineParser::setOptions(int _argc, char **_argv)
{
  argc = _argc;
  argv = _argv;
  cmdline_options.add(generic).add(config).add(hidden);
  config_file_options.add(config).add(hidden);
  visible.add(generic).add(config);
}

/** Makes the Parser parse the command line options with current known options.
 * \param _argc arg count from main()
 * \param **_argv argument array from main()
 */
void CommandLineParser::Run(int _argc, char **_argv)
{
  setOptions(argc,argv);
  Parse();
}

CONSTRUCT_SINGLETON(CommandLineParser)
