/*
 * GLWorldScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLWORLDSCENE_HPP_
#define GLWORLDSCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Qt/qobject.h>

#include <iosfwd>

#include "Bond/bond.hpp"
#include "GLMoleculeObject_bond.hpp"
#include "GLMoleculeObject_molecule.hpp"
#include "types.hpp"

class atom;
class molecule;
class Shape;

class QGLPainter;
class QGLSceneNode;
class QGLView;

class GLMoleculeObject;
class GLMoleculeObject_atom;
class GLMoleculeObject_molecule;
class GLMoleculeObject_shape;

/** This class contains a list of all molecules in the world.
 *
 */
class GLWorldScene : public QObject
{
  Q_OBJECT
public:
  GLWorldScene(QObject *parent=0);
  virtual ~GLWorldScene();

//#if !defined(QT_OPENGL_ES_1)
//  PerPixelEffect *lighting;
//#endif

  void changeMaterials(bool perPixel);
  QGLSceneNode* getAtom(size_t);
  QGLSceneNode* getMolecule(size_t);
  QGLSceneNode* getBond(size_t, size_t);

  void initialize(QGLView *view, QGLPainter *painter) const;
  void draw(QGLPainter *painter, const QVector4D &cameraPlane) const;

  enum SelectionModeType{
    SelectAtom,
    SelectMolecule
  };
  void setSelectionMode(SelectionModeType mode);

signals:
  void changed();
  void changeOccured();
  void pressed();
  void released();
  void clicked();
  void clicked(atomId_t);
  void doubleClicked();
  void hoverChanged(const atom*);

private slots:
  void atomClicked(atomId_t no);
  void atomInserted(const atom *_atom);
  void atomRemoved(const atomicNumber_t _id);
  void moleculeRemoved(const molecule *_molecule);
  void worldSelectionChanged();
  void bondInserted(const bond::ptr _bond, const GLMoleculeObject_bond::SideOfBond side);
  void bondRemoved(const atomId_t leftnr, const atomId_t rightnr);
  void setSelectionModeAtom();
  void setSelectionModeMolecule();
  void hoverChangedSignalled(GLMoleculeObject *ob);
  void changeAtomId(GLMoleculeObject_atom *ob, int oldId, int newOd);
  void addShape();
  void removeShape();

public:
  void updateSelectedShapes();

private:
  void init();

private:
  typedef std::pair< atomId_t, atomId_t> BondIds;
  friend std::ostream &operator<<(std::ostream &ost, const BondIds &t);

  typedef std::map< atomId_t, GLMoleculeObject_atom* > AtomNodeMap;
  typedef std::map< BondIds , GLMoleculeObject_bond* > BondNodeMap;
  typedef std::map< moleculeId_t , GLMoleculeObject_molecule* > MoleculeNodeMap;
  typedef std::map< std::string , GLMoleculeObject_shape* > ShapeNodeMap;
  AtomNodeMap AtomsinSceneMap;
  BondNodeMap BondsinSceneMap;
  MoleculeNodeMap MoleculesinSceneMap;
  ShapeNodeMap ShapesinSceneMap;

  QGLSceneNode *meshEmpty[GLMoleculeObject::DETAILTYPES_MAX];
  QGLSceneNode *meshSphere[GLMoleculeObject::DETAILTYPES_MAX];
  QGLSceneNode *meshCylinder[GLMoleculeObject::DETAILTYPES_MAX];

  SelectionModeType selectionMode;
  const atom *hoverAtom;
};

std::ostream &operator<<(std::ostream &ost, const GLWorldScene::BondIds &t);

#endif /* GLWORLDSCENE_HPP_ */
