/*
 * SetOutputFormatsAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/SetOutputFormatsAction.hpp"
#include "Parser/ChangeTracker.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char WorldSetOutputFormatsAction::NAME[] = "set-output";

WorldSetOutputFormatsAction::WorldSetOutputFormatsAction() :
  Action(NAME)
{}

WorldSetOutputFormatsAction::~WorldSetOutputFormatsAction()
{}

Action::state_ptr WorldSetOutputFormatsAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  vector<std::string> FormatList;

  dialog->queryStrings(NAME, &FormatList, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    for (vector<std::string>::iterator iter = FormatList.begin(); iter != FormatList.end(); ++iter) {
      if (*iter == "mpqc") {
        FormatParserStorage::getInstance().addMpqc();
        DoLog(0) && (Log() << Verbose(0) << "Adding mpqc type to output." << endl);
      } else if (*iter == "pcp") {
        FormatParserStorage::getInstance().addPcp();
        DoLog(0) && (Log() << Verbose(0) << "Adding pcp type to output." << endl);
      } else if (*iter == "tremolo") {
        FormatParserStorage::getInstance().addTremolo();
        DoLog(0) && (Log() << Verbose(0) << "Adding tremolo type to output." << endl);
      } else if (*iter == "xyz") {
        FormatParserStorage::getInstance().addXyz();
        DoLog(0) && (Log() << Verbose(0) << "Adding xyz type to output." << endl);
      } else {
        DoeLog(1) && (eLog() << Verbose(1) << "Unknown format." << endl);
      }
    }
    ChangeTracker::getInstance().saveStatus();
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldSetOutputFormatsAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldSetOutputFormatsAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldSetOutputFormatsAction::canUndo() {
  return false;
}

bool WorldSetOutputFormatsAction::shouldUndo() {
  return false;
}

const string WorldSetOutputFormatsAction::getName() {
  return NAME;
}
