/*
 * CenterOnEdgeAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/CenterOnEdgeAction.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"
#include "Helpers/Assert.hpp"

const char WorldCenterOnEdgeAction::NAME[] = "center-edge";

WorldCenterOnEdgeAction::WorldCenterOnEdgeAction() :
  Action(NAME)
{}

WorldCenterOnEdgeAction::~WorldCenterOnEdgeAction()
{}

Action::state_ptr WorldCenterOnEdgeAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  Vector Min;
  Vector Max;
  int j=0;

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    // get maximum and minimum
    vector<atom *> AllAtoms = World::getInstance().getAllAtoms();
    ASSERT(AllAtoms.size() > 0, "For CenteronEdge atoms must be present.");
    vector<atom *>::iterator AtomRunner = AllAtoms.begin();
    Min = (*AtomRunner)->x;
    Max = (*AtomRunner)->x;
    for (; AtomRunner != AllAtoms.end(); ++AtomRunner) {
      for (int i=0;i<NDIM;i++) {
        if ((*AtomRunner)->x[i] > Max[i])
          Max[i] = (*AtomRunner)->x[i];
        if ((*AtomRunner)->x[i] < Min[i])
          Min[i] = (*AtomRunner)->x[i];
      }
    }
    // set new box size
    double * const cell_size = World::getInstance().getDomain();
    for (j=0;j<6;j++)
      cell_size[j] = 0.;
    j=-1;
    for (int i=0;i<NDIM;i++) {
      j += i+1;
      cell_size[j] = (Max[i]-Min[i]);
    }
    World::getInstance().setDomain(cell_size);
    // translate all atoms, such that Min is aty (0,0,0)
    for (vector<atom*>::iterator AtomRunner = AllAtoms.begin(); AtomRunner != AllAtoms.end(); ++AtomRunner)
      (*AtomRunner)->x -= Min;
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr WorldCenterOnEdgeAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterOnEdgeAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterOnEdgeAction::canUndo() {
  return false;
}

bool WorldCenterOnEdgeAction::shouldUndo() {
  return false;
}

const string WorldCenterOnEdgeAction::getName() {
  return NAME;
}
