/*
 * \file memoryusageobserver.hpp
 *
 * This class represents a Singleton for observing memory usage.
 */
#ifndef MEMORYUSAGEOBSERVER_HPP_
#define MEMORYUSAGEOBSERVER_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <math.h>
#include <string>
#include <typeinfo>

class MemoryUsageObserver {
public:
  static MemoryUsageObserver* getInstance();
  static void purgeInstance();
  void addMemory(void* pointer, size_t size);
  void removeMemory(void* pointer, const char *msg = NULL);
  size_t getUsedMemorySize();
  size_t getMaximumUsedMemory();

protected:
  /** Do not call this constructor directly, use getInstance() instead. */
  MemoryUsageObserver();
  /** Do not call this destructor directly, use purgeInstance() instead. */
  ~MemoryUsageObserver();

private:
  static MemoryUsageObserver* instance;
  map<void*, size_t> memoryUsers;
  size_t totalSize, maximumSize;
};
#endif /*MEMORYUSAGEOBSERVER_HPP_*/
