/*
 * RandomNumberEngineFactory.hpp
 *
 *  Created on: Jan 03, 2011
 *      Author: heber
 */

#ifndef RANDOMNUMBERENGINEFACTORY_HPP_
#define RANDOMNUMBERENGINEFACTORY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"

#include "RandomNumberEngine.hpp"
#include "RandomNumberEngine_Parameters.hpp"

// this defines stuff necessary PREVIOUS of PrototypeFactory.hpp inclusion
#include "RandomNumberEngineFactory.def"
#include "CodePatterns/FactoryTypeList.hpp"
#include "RandomNumberEngineFactory.undef"

#include "CodePatterns/ManipulablePrototypeFactory.hpp"

#include <map>

class RandomNumberEngineFactoryUnitTest;
class CommandSetRandomNumbersEngineAction;

/** This is the Prototype factory class for random number engines.
 *
 * The reason for creating the engines as this is that we would like to set
 * the engines parameters, via some Action, and then onward only have
 * random number engines of this type using these parameters. Hence, we have
 * a singleton factory that is controlled by the Action and can then create
 * engines wherever we like in the code by having the factory create one.
 *
 */
class RandomNumberEngineFactory :
  public Singleton<RandomNumberEngineFactory>,
  public ManipulablePrototypeFactory<RandomNumberEngine,RandomNumberEngine_Parameters>
{
  friend class Singleton<RandomNumberEngineFactory>;
  friend class RandomNumberEngineFactoryTest;
  friend class CommandSetRandomNumbersEngineAction;

protected:
  void FillPrototypeTable();
  void EmptyPrototypeTable();

  RandomNumberEngineFactory();
  virtual ~RandomNumberEngineFactory();

};

#endif /* RANDOMNUMBERENGINEFACTORY_HPP_ */
