/*
 * SphericalPointDistributionUnitTest.hpp
 *
 *  Created on: May 29, 2014
 *      Author: heber
 */

#ifndef SPHERICALPOINTDISTRIBUTIONUNITTEST_HPP_
#define SPHERICALPOINTDISTRIBUTIONUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

/********************************************** Test classes **************************************/

/** Template specialization needs to be in front of adding the test via CPPUNIT_TEST
 * Hence,we put it in an extra class and inherit the functions.
 */
struct SphericalPointDistributionTest_assistant
{
public:
  template <int N>
  void getConnectionTest();
};

template <> void SphericalPointDistributionTest_assistant::getConnectionTest<0>();
template <> void SphericalPointDistributionTest_assistant::getConnectionTest<1>();
template <> void SphericalPointDistributionTest_assistant::getConnectionTest<2>();

#include "SphericalPointDistributionUnitTest_assistant.hpp"

class SphericalPointDistributionTest :
  public CppUnit::TestFixture,
  public SphericalPointDistributionTest_assistant
{

private:
    CPPUNIT_TEST_SUITE( SphericalPointDistributionTest) ;
    CPPUNIT_TEST( calculateCenterOfMinimumDistanceTest );
    CPPUNIT_TEST ( areEqualToWithinBoundsTest );
    CPPUNIT_TEST ( joinPointsTest );
    CPPUNIT_TEST ( getConnectionTest<0> );
    CPPUNIT_TEST ( getConnectionTest<1> );
    CPPUNIT_TEST ( getConnectionTest<2> );
    CPPUNIT_TEST ( getConnectionTest<3> );
    CPPUNIT_TEST ( getConnectionTest<4> );
    CPPUNIT_TEST ( getConnectionTest<5> );
    CPPUNIT_TEST ( getConnectionTest<6> );
    CPPUNIT_TEST ( getConnectionTest<7> );
    CPPUNIT_TEST ( getConnectionTest<8> );
    CPPUNIT_TEST ( getConnectionTest<9> );
    CPPUNIT_TEST ( getConnectionTest<10> );
    CPPUNIT_TEST ( getConnectionTest<11> );
    CPPUNIT_TEST ( getConnectionTest<12> );
    CPPUNIT_TEST ( getConnectionTest<14> );
    CPPUNIT_TEST ( getRemainingPointsTest_2 );
    CPPUNIT_TEST ( getRemainingPointsTest_3 );
    CPPUNIT_TEST ( getRemainingPointsTest_4 );
    CPPUNIT_TEST ( getRemainingPointsTest_5 );
    CPPUNIT_TEST ( getRemainingPointsTest_6 );
    CPPUNIT_TEST ( getRemainingPointsTest_7 );
    CPPUNIT_TEST ( getRemainingPointsTest_8 );
    CPPUNIT_TEST ( getRemainingPointsTest_multiple );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void calculateCenterOfMinimumDistanceTest();
      void areEqualToWithinBoundsTest();
      void joinPointsTest();
      void getRemainingPointsTest_2();
      void getRemainingPointsTest_3();
      void getRemainingPointsTest_4();
      void getRemainingPointsTest_5();
      void getRemainingPointsTest_6();
      void getRemainingPointsTest_7();
      void getRemainingPointsTest_8();
      void getRemainingPointsTest_multiple();

private:
};

#endif /* SPHERICALPOINTDISTRIBUTIONUNITTEST_HPP_ */
