/*
 * Space.cpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "LinearAlgebra/Space.hpp"
#include "LinearAlgebra/Vector.hpp"

Space::Space()
{}

Space::~Space()
{}

bool Space::hasZero() const{
  return isContained(zeroVec);
}

Vector Space::getVectorToPoint(const Vector &origin) const{
  Vector support = getClosestPoint(origin);
  return support-origin;
}

bool Space::isContained(const Vector &point) const{
  return (distance(point)) < MYEPSILON;
}
