/*
 * MoleculeView.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef MOLECULEVIEW_HPP_
#define MOLECULEVIEW_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include <QtGui/QTabWidget>
#include <QtGui/QTreeWidget>
#include <QTimer>
#include "CodePatterns/Observer/Observer.hpp"

class molecule;
class atom;

// Forwarding of the Tab-Pages
class QTAtomPage;
class QTMoleculePage;

class QtMoleculeView : public QTabWidget
{
  Q_OBJECT
public:
  QtMoleculeView();
  virtual ~QtMoleculeView();

  void showAtom(const atom *_atom);

public slots:
  void atomHover(const atom *_atom);
  void timerTimeout();

  void nameChanged(QTMoleculePage *page, std::string name);
  void clearTabs();

private:
  const atom *curAtom;
  const atom *nextAtom;
  QTMoleculePage *page_mol;
  QTAtomPage *page_atom;

  QTimer *timer;
};

/**
 * Widget to display the tab page for a single atom
 */
class QTAtomPage : public QWidget, public Observer {
  Q_OBJECT
public:
  QTAtomPage(const atom *_atom);
  virtual ~QTAtomPage();
  void update(Observable *subject);
  void subjectKilled(Observable *subject);

signals:
  void atomKilled();

private:
  const atom *atomRef;
  QTreeWidget *info;
};

/**
 * Widget to display the tab page for a single molecule
 */
class QTMoleculePage : public QWidget,  public Observer {
  Q_OBJECT
public:
  QTMoleculePage(const molecule *_mol);
  virtual ~QTMoleculePage();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);

  signals:
    void moleculeKilled();

private:
  const molecule *mol;
  QTreeWidget *info;
};
#endif /* MOLECULEVIEW_HPP_ */
