/*
 * ConvexEnvelopeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/TesselationAction/ConvexEnvelopeAction.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"
#include "World.hpp"

/****** TesselationConvexEnvelopeAction *****/

// memento to remember the state when undoing

//class TesselationConvexEnvelopeState : public ActionState {
//public:
//  TesselationConvexEnvelopeState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char TesselationConvexEnvelopeAction::NAME[] = "convex-envelope";

TesselationConvexEnvelopeAction::TesselationConvexEnvelopeAction() :
  Action(NAME)
{}

TesselationConvexEnvelopeAction::~TesselationConvexEnvelopeAction()
{}

Action::state_ptr TesselationConvexEnvelopeAction::performCall() {
  string filenameConvex;
  string filenameNonConvex;
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule * mol = NULL;
  bool Success = false;
  config *configuration = World::getInstance().getConfig();

  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryString("convex-file", &filenameConvex, MapOfActions::getInstance().getDescription("convex-file"));
  dialog->queryString("nonconvex-file", &filenameNonConvex, MapOfActions::getInstance().getDescription("nonconvex-file"));

  if(dialog->display()) {
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating volume of the convex envelope.");
    DoLog(1) && (Log() << Verbose(1) << "Storing tecplot convex data in " << filenameConvex << "." << endl);
    DoLog(1) && (Log() << Verbose(1) << "Storing tecplot non-convex data in " << filenameNonConvex << "." << endl);
    LCList = new LinkedCell(mol, 100.);
    Boundaries *BoundaryPoints = NULL;
    //FindConvexBorder(mol, BoundaryPoints, TesselStruct, LCList, argv[argptr]);
    // TODO: Beide Funktionen sollten streams anstelle des Filenamen benutzen, besser fuer unit tests
    FindNonConvexBorder(mol, TesselStruct, LCList, 50., filenameNonConvex.c_str());
    //RemoveAllBoundaryPoints(TesselStruct, mol, argv[argptr]);
    const double volumedifference = ConvexizeNonconvexEnvelope(TesselStruct, mol, filenameConvex.c_str());
    const double clustervolume = VolumeOfConvexEnvelope(TesselStruct, configuration);
    DoLog(0) && (Log() << Verbose(0) << "The tesselated volume area is " << clustervolume << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    DoLog(0) && (Log() << Verbose(0) << "The non-convex tesselated volume area is " << clustervolume-volumedifference << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    delete(TesselStruct);
    delete(LCList);
    delete dialog;
    if (Success)
      return Action::success;
    else
      return Action::failure;
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr TesselationConvexEnvelopeAction::performUndo(Action::state_ptr _state) {
//  TesselationConvexEnvelopeState *state = assert_cast<TesselationConvexEnvelopeState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr TesselationConvexEnvelopeAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool TesselationConvexEnvelopeAction::canUndo() {
  return false;
}

bool TesselationConvexEnvelopeAction::shouldUndo() {
  return false;
}

const string TesselationConvexEnvelopeAction::getName() {
  return NAME;
}
