/*
 * MolecularVolumeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AnalysisAction/MolecularVolumeAction.hpp"
#include "boundary.hpp"
#include "config.hpp"
#include "molecule.hpp"
#include "linkedcell.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AnalysisMolecularVolumeAction::NAME[] = "molecular-volume";

AnalysisMolecularVolumeAction::AnalysisMolecularVolumeAction() :
  Action(NAME)
{}

AnalysisMolecularVolumeAction::~AnalysisMolecularVolumeAction()
{}

Action::state_ptr AnalysisMolecularVolumeAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  molecule *mol = NULL;

  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));

  if(dialog->display()) {
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating volume of the convex envelope.");
    LCList = new LinkedCell(mol, 10.);
    config * const configuration = World::getInstance().getConfig();
    Boundaries *BoundaryPoints = NULL;
    //FindConvexBorder(mol, BoundaryPoints, TesselStruct, LCList, argv[argptr]);
    FindNonConvexBorder(mol, TesselStruct, LCList, 5., NULL);
    //RemoveAllBoundaryPoints(TesselStruct, mol, argv[argptr]);
    double volumedifference = ConvexizeNonconvexEnvelope(TesselStruct, mol, NULL);
    double clustervolume = VolumeOfConvexEnvelope(TesselStruct, configuration);
    DoLog(0) && (Log() << Verbose(0) << "The tesselated volume area is " << clustervolume << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    DoLog(0) && (Log() << Verbose(0) << "The non-convex tesselated volume area is " << clustervolume-volumedifference << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    delete(TesselStruct);
    delete(LCList);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr AnalysisMolecularVolumeAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AnalysisMolecularVolumeAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AnalysisMolecularVolumeAction::canUndo() {
  return false;
}

bool AnalysisMolecularVolumeAction::shouldUndo() {
  return false;
}

const string AnalysisMolecularVolumeAction::getName() {
  return NAME;
}
