/*
 * atom_particleinfo.hpp
 *
 *  Created on: Oct 19, 2009
 *      Author: heber
 */

#ifndef ATOM_PARTICLEINFO_HPP_
#define ATOM_PARTICLEINFO_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

/****************************************** forward declarations *****************************/


/********************************************** declarations *******************************/

class ParticleInfo {
public:
  int nr;       // index to easierly identify

  ParticleInfo();
  ParticleInfo(ParticleInfo*);
  virtual ~ParticleInfo();

  /** Getter for name.
   *
   * @return name of particle
   */
  const std::string& getName() const;
  /** Getter for nr.
   *
   * @return number of particle
   */
  const int& getNr() const;
  /** Setter for name.
   *
   * @param newname new name of particle
   */
  void setName(const std::string &newname);

  ostream & operator << (ostream &ost) const;

private:
  std::string name;   // some name to reference to on output
};

ostream & operator << (ostream &ost, const ParticleInfo &a);

#endif /* ATOM_PARTICLEINFO_HPP_ */
