/*
 * TesselPoint.hpp
 *
 *  Created on: Jul 30, 2010
 *      Author: heber
 */

#ifndef TESSELPOINT_HPP_
#define TESSELPOINT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "atom_atominfo.hpp"
#include "atom_particleinfo.hpp"

class TesselPoint;

class TesselPoint : public virtual ParticleInfo, public virtual AtomInfo
{
public:
  TesselPoint();
  ~TesselPoint();

  /** Pushes back another step in all trajectory vectors.
   *
   * This allows to extend all trajectories contained in different classes
   * consistently. This is implemented by the topmost class which calls the
   * real functions, \sa AppendTrajectoryStep(), by all necessary subclasses.
   *
   * Note that this function is actually not sensible with TesselPoints
   * as they should not have trajectories but is implemented as they can be
   * used stand-alone.
   *
   */
  virtual void UpdateSteps();

  /** Getter for this.
   *
   *  \note this is only present due to BoundaryPointSet, where TesselPoint is
   *   only embedded and PointCloud where we have to access this TesselPoint.
   *
   * @return reference to embedded TesselPoint \a node
   */
  TesselPoint *getTesselPoint();

  std::ostream & operator << (std::ostream &ost) const;
};

std::ostream & operator << (std::ostream &ost, const TesselPoint &t);

#endif /* TESSELPOINT_HPP_ */
