/*
 * BoundaryPointSet.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: heber
 */

#ifndef BOUNDARYPOINTSET_HPP_
#define BOUNDARYPOINTSET_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "BoundaryMaps.hpp"

#include <iostream>
#include <map>

class BoundaryLineSet;
class TesselPoint;
class Vector;

class BoundaryPointSet {
  public:
    BoundaryPointSet();
    BoundaryPointSet(TesselPoint * const Walker);
    ~BoundaryPointSet();

    void AddLine(BoundaryLineSet * const line);

    LineMap lines;
    int LinesCount;
    TesselPoint *node;
    double value;
    int Nr;

    /** Getter for \a node's getName().
     *
     * @return getName() of \a node
     */
    const std::string& getName() const;

    /** Getter for \a node's getPosition().
     *
     * @return getPosition() of \a node
     */
    const Vector& getPosition() const;

    /** Getter for \a node's nr.
     *
     * @return nr of \a node
     */
    const int& getNr() const;

    /** Getter for embedded TesselPoint.
     *
     * @return reference to embedded TesselPoint \a node
     */
    TesselPoint *getTesselPoint();
};

/** output operator for BoundaryPointSet.
 * \param &ost output stream
 * \param &a boundary point
 */
std::ostream & operator << (std::ostream &ost, const BoundaryPointSet &a);

#endif /* BOUNDARYPOINTSET_HPP_ */
