/*
 * RangeValidator_impl.hpp
 *
 *  Created on: Apr 16, 2012
 *      Author: ankele
 */

#ifndef RANGEVALIDATOR_IMPL_HPP_
#define RANGEVALIDATOR_IMPL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

template <class T>
bool RangeValidator<T>::isValid(const T & _value) const
{
  bool isBefore = true;
  bool isBeyond = true;
  // check left boundary
  isBefore = ValidRange.isBefore(_value);
//  if (isBefore)
//    LOG(0, "INFO: " << _value << " is before " << ValidRange.first << ".");
  // check right boundary
  isBeyond = ValidRange.isBeyond(_value) && (_value != ValidRange.last);
//  if (isBeyond)
//    LOG(0, "INFO: " << _value << " is beyond " << ValidRange.last << ".");
  return (!isBefore) && (!isBeyond);
}

template <class T>
Validator<T>* RangeValidator<T>::clone() const
{
  return new RangeValidator<T>(ValidRange);
};

// comparator
template <class T>
bool RangeValidator<T>::operator==(const Validator<T> &_instance) const
{
  const RangeValidator<T> *inst = dynamic_cast<const RangeValidator<T> *>(&_instance);
  if (inst)
    return ValidRange == inst->ValidRange;
  return false;
};


/** Setter for the valid range.
 *
 * If value is invalid in new range, we throw AssertFailure and set ValueSet to false.
 *
 * @param _range range (pair of values)
 */
template <class T>
void RangeValidator<T>::setValidRange(const range<T> &_range)
{
  ValidRange = _range;
}






// specialization for Vector
#include "LinearAlgebra/Vector.hpp"

class Vector;

template <>
inline bool RangeValidator<Vector>::isValid(const Vector & _value) const
{
  return ValidRange.first[0] <= _value[0] && _value[0] < ValidRange.last[0] &&
         ValidRange.first[1] <= _value[1] && _value[1] < ValidRange.last[1] &&
         ValidRange.first[2] <= _value[2] && _value[2] < ValidRange.last[2];
}


#endif /* RANGEVALIDATOR_IMPL_HPP_ */
