/*
 * Parameter_impl.hpp
 *
 *  Created on: Apr 16, 2012
 *      Author: ankele
 */

#ifndef PARAMETER_IMPL_HPP_
#define PARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Parameter.hpp"

/** Constructor for class Parameter.
 *
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name) :
  ParameterInterface<T>(_name),
  Value<T>()
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const T &_value) :
  ParameterInterface<T>(_name),
  Value<T>()
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const Validator<T> &_Validator) :
  ParameterInterface<T>(_name),
  Value<T>(_Validator)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const Validator<T> &_Validator, const T &_value) :
  ParameterInterface<T>(_name),
  Value<T>(_Validator)
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const std::vector<T> &_ValidValues) :
  ParameterInterface<T>(_name),
  Value<T>(_ValidValues)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const std::vector<T> &_ValidValues, const T &_value) :
  ParameterInterface<T>(_name),
  Value<T>(_ValidValues)
{
  Value<T>::set(_value);
};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const range<T> &_ValidRange) :
  ParameterInterface<T>(_name),
  Value<T>(_ValidRange)
{};

/** Constructor for class Parameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 * @param _value initial value to set
 */
template<typename T>
Parameter<T>::Parameter(const std::string &_name, const range<T> &_ValidRange, const T &_value) :
  ParameterInterface<T>(_name),
  Value<T>(_ValidRange)
{
  Value<T>::set(_value);
};

/** Destructor for class Parameter.
 *
 */
template<typename T>
Parameter<T>::~Parameter()
{};

/** Compares this continuous value against another \a _instance.
 *
 * @param _instance other value to compare to
 * @return true - if contained ContinuousValue and name are the same, false - else
 */
template <class T>
bool Parameter<T>::operator==(const Parameter<T> &_instance) const
{
  bool status = true;
  status = status &&
      (*dynamic_cast<const Value<T> *>(this) == dynamic_cast<const Value<T> &>(_instance));
  status = status && (ParameterInterface<T>::getName() == _instance.ParameterInterface<T>::getName());
  return status;
}

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
ParameterAsString* Parameter<T>::clone() const
{
  Parameter<T> *instance = new Parameter<T>(ParameterInterface<T>::getName(), Value<T>::getValidator());
  if (Value<T>::ValueSet)
    instance->set(Value<T>::get());
  return instance;
}


#endif /* Parameter_IMPL_HPP_ */
