/*
 * Parameter.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef PARAMETERINTERFACE_HPP_
#define PARAMETERINTERFACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Parameters/ValueInterface.hpp"
#include "Parameters/ParameterAsString.hpp"


/** This interface represents a clonable, named Value.
 *
 */
template <class T>
class ParameterInterface : virtual public ParameterAsString, virtual public ValueInterface<T>
{
public:
  ParameterInterface(const std::string &_name) : name(_name) {}
  virtual ~ParameterInterface() {}

  const std::string &getName() const { return name; }

private:
  ParameterInterface();

private:
  const std::string name;
};


#endif /* PARAMETERINTERFACE_HPP_ */
