/*
 * Parameter.hpp
 *
 *  Created on: Apr 16, 2012
 *      Author: ankele
 */

#ifndef PARAMETER_HPP_
#define PARAMETER_HPP_



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Value.hpp"
#include "ParameterInterface.hpp"

/** This class encapsulates a clonable, continuous value.
 *
 */
template <typename T>
class Parameter : public ParameterInterface<T>, public Value<T>
{
public:
  Parameter(const std::string &_name);
  Parameter(const std::string &_name, const T &_value);
  Parameter(const std::string &_name, const Validator<T> &_Validator);
  Parameter(const std::string &_name, const Validator<T> &_Validator, const T &_value);
  Parameter(const std::string &_name, const std::vector<T> &_ValidValues);
  Parameter(const std::string &_name, const std::vector<T> &_ValidValues, const T &_value);
  Parameter(const std::string &_name, const range<T> &_ValidRange);
  Parameter(const std::string &_name, const range<T> &_ValidRange, const T &_value);
  virtual ~Parameter();

  // comparator
  bool operator==(const Parameter<T> &_instance) const;
  bool operator!=(const Parameter<T> &_instance) const
      { return !((*this)==(_instance)); }

  ParameterAsString* clone() const;

private:
  Parameter();
};

#include "Parameter_impl.hpp"


#endif /* PARAMETER_HPP_ */
