/*
 * XyzParser.cpp
 *
 *  Created on: Mar 2, 2010
 *      Author: metzler
 */

#include "XyzParser.hpp"
#include "World.hpp"
#include "atom.hpp"
#include "element.hpp"
#include "periodentafel.hpp"

using namespace std;

/**
 * Constructor.
 */
XyzParser::XyzParser() {
  comment = "";
}

/**
 * Destructor.
 */
XyzParser::~XyzParser() {
  delete(&comment);
}

/**
 * Loads an XYZ file into the World.
 *
 * \param XYZ file
 */
void XyzParser::load(istream* file) {
  atom* newAtom;
  int numberOfAtoms;
  char commentBuffer[512], type[3];

  // the first line tells number of atoms, the second line is always a comment
  *file >> numberOfAtoms >> ws;
  file->getline(commentBuffer, 512);
  comment = commentBuffer;

  for (int i = 0; i < numberOfAtoms; i++) {
    newAtom = World::getInstance().createAtom();
    *file >> type >> ws >> newAtom->x[0] >> ws >> newAtom->x[1] >> ws >> newAtom->x[2];
    newAtom->setType(World::getInstance().getPeriode()->FindElement(type));
  }
}

/**
 * Saves the current state of the World into the given XYZ file.
 *
 * \param XYZ file
 */
void XyzParser::save(ostream* file) {
  *file << World::getInstance().numAtoms() << endl << comment << endl;

  vector<atom*> atoms = World::getInstance().getAllAtoms();
  for(vector<atom*>::iterator it = atoms.begin(); it < atoms.end(); it++) {
    *file << fixed << (*it)->getType()->symbol << "\t" << (*it)->x[0] << "\t" << (*it)->x[1] << "\t" << (*it)->x[2] << endl;
  }
}
