/*
 * QTMenu.hpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#ifndef QTMENU_HPP_
#define QTMENU_HPP_

#include <list>

#include <QtGui/QMenu>
#include <QtCore/QObject>

#include "Menu/Menu.hpp"

class QTMenuPipe;

class QTMenu : public QMenu, public Menu
{
  Q_OBJECT

public:
  QTMenu(const char *);
  virtual ~QTMenu();

  virtual void addItem(MenuItem*);
  virtual void removeItem(MenuItem*);
  virtual void display();
private:
  list<QTMenuPipe*> plumbing;
};

// This handles the plumbing from QT to internal Items
// Slots from QT are redirected to internal methods.
// This way methods can be used where no QT is available
class QTMenuPipe : public QObject {
  Q_OBJECT
public:
  QTMenuPipe(MenuItem*,QAction*);
  virtual ~QTMenuPipe();
public slots:
  void called();
private:
  MenuItem *theItem;
  QAction *theAction;
};

#endif /* QTMENU_HPP_ */
