/*
 * QTMenu.cpp
 *
 *  Created on: Jan 15, 2010
 *      Author: crueger
 */

#include "Menu/QT4/QTMenu.hpp"

#include <Qt/qaction.h>
#include "Menu/MenuItem.hpp"

QTMenu::QTMenu(const char * _title) :
  QMenu(_title)
{}

QTMenu::~QTMenu()
{
  // yay... Just like Mario Bros.
  for(list<QTMenuPipe*>::iterator it=plumbing.begin(); it != plumbing.end(); it++)
    delete (*it);
}

void QTMenu::addItem(MenuItem* item) {
  const string description = item->getDescription();
  QAction *action = addAction(QString(description.c_str()));
  QTMenuPipe *pipe = new QTMenuPipe(item,action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
}

void QTMenu::removeItem(MenuItem* item) {
  list<QTMenuPipe*>::iterator iter;
  for(iter=plumbing.begin(); iter!=plumbing.end(); iter++){
    delete (*iter);
  }
}

void QTMenu::display() {

}

QTMenuPipe::QTMenuPipe(MenuItem *_item, QAction *_action) :
    theItem(_item), theAction(_action)
{}

QTMenuPipe::~QTMenuPipe() {
  delete theAction;
  delete theItem;
}

void QTMenuPipe::called() {
  theItem->doTrigger();
}
