/*
 * AnyFillPredicate.hpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */

#ifndef ANYFILLPREDICATE_HPP_
#define ANYFILLPREDICATE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/function.hpp>

#include "FillPredicateBase.hpp"
#include "types.hpp"


/** Allows arbitrarily bound boolean functions to represent a predicate.
 *
 */
class AnyFillPredicate : public FillPredicateBase
{
public:
  //!> specific type of the predicate function
  typedef boost::function<bool(const Node&)> FillPredicator;

  AnyFillPredicate(FillPredicator &_function);
  virtual ~AnyFillPredicate();

  bool operator()(const Node&n) const;

private:
  FillPredicator function;
};


#endif /* ANYFILLPREDICATE_HPP_ */
