/*
 * UndoRedoHelpers.hpp
 *
 *  Created on: Apr 5, 2012
 *      Author: heber
 */

#ifndef UNDOREDOHELPERS_HPP_
#define UNDOREDOHELPERS_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>

#include "Atom/AtomicInfo.hpp"
#include "Bond/BondInfo.hpp"

namespace MoleCuilder {

  /** Adds removed atoms back to the world whose state is stored as AtomicInfo.
   *
   * @param atoms vector of atomicInfo
   * @return restoral was successful, at least atom could not be restored.
   */
  bool AddAtomsFromAtomicInfo(std::vector<AtomicInfo> &atoms);

  /** Removes atoms whose state information is stored as AtomicInfo.
   *
   * @param atoms vector of atomicInfo
   */
  void RemoveAtomsFromAtomicInfo(std::vector<AtomicInfo> &atoms);

  /** Stores the required bond information in for all \a atoms in \a bonds.
   *
   * @param atoms atoms whose bonds to store
   * @param bonds vector with bond information on return
   */
  void StoreBondInformationFromAtoms(
      const std::vector<const atom*> &atoms,
      std::vector<BondInfo> &bonds);

  /** Recreates bonds from information stored in \a bonds.
   *
   * @param bonds bond state information
   * @return true - all bonds restored, false - at least one bond could not be restored
   */
  bool AddBondsFromBondInfo(const std::vector< BondInfo > &bonds);

  /** Sets atoms to state information stored as AtomicInfo.
   *
   * @param movedatoms vector of atomicInfo
   */
  void SetAtomsFromAtomicInfo(std::vector<AtomicInfo> &movedatoms);

  /** Selects all atoms inside the given vector
   *
   * @param movedatoms vector of atomicInfo
   */
  void SelectAtomsFromAtomicInfo(std::vector<AtomicInfo> &movedatoms);

  /** Sets the atoms whose id is stored in given AtomicInfo in \a movedatoms
   *  to position in \a MovedToVector.
   *
   * @param movedatoms atoms whose position to change
   * @param MovedToVector vector with old positions
   */
  void ResetAtomPosition(const std::vector<AtomicInfo> &movedatoms, const std::vector<Vector> &MovedToVector);
}



#endif /* UNDOREDOHELPERS_HPP_ */
