dnl
dnl AM_PATH_CODEPATTERNS(MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl

AC_DEFUN([AM_PATH_CODEPATTERNS],
[
AC_REQUIRE([AX_BOOST_THREAD])

AC_ARG_WITH(codepatterns,[  --with-codepatterns=PFX   Prefix where CodePatterns is installed (optional)],
            codepatterns_prefix="$withval", codepatterns_prefix="")
AC_ARG_WITH(codepatterns_include,[  --with-codepatterns_include=INCLUDE   Where CodePatterns' includes are installed (optional)],
            codepatterns_include_prefix="$withval", codepatterns_include_prefix="")
AC_ARG_WITH(cp_cv_codepatterns_libs,[  --with-cp_cv_codepatterns_libs=LIBPATH   Where CodePatterns' libs are installed (optional)],
            cp_cv_codepatterns_libs_prefix="$withval", cp_cv_codepatterns_libs_prefix="")

  codepatterns_version_min=$1

  CodePatterns_CFLAGS=""
  CodePatterns_LIBS=""
  CodePatterns_LDFLAGS=""

 
  codepatterns_pkgconfig=""
  # try to set PKG_CONFIG_PATH
  if test x$codepatterns_prefix != xno; then
    if test -z $PKG_CONFIG_PATH; then
      export PKG_CONFIG_PATH="$codepatterns_prefix/lib/pkgconfig/"
    else
      export PKG_CONFIG_PATH="$codepatterns_prefix/lib/pkgconfig/:$PKG_CONFIG_PATH"
    fi
  fi
  # 1. test whether pkg-config works
  CodePatterns_CONFIG=""
  #AC_MSG_NOTICE([PKG_CONFIG_PATH is $PKG_CONFIG_PATH])
  PKG_CHECK_MODULES([CodePatterns], [CodePatterns >= $codepatterns_version_min], [
      codepatterns_pkgconfig=yes
      CodePatterns_CONFIG="pkg-config CodePatterns"
    ], [
    # 2. if failed, test for binary codepatterns-config
      AC_PATH_PROG(CodePatterns_CONFIG, codepatterns-config, no)
      if test x$CodePatterns_CONFIG = xno && test x$codepatterns_prefix != x ; then
        AC_MSG_CHECKING([for alternative codepatterns-config location])
        if test -e $codepatterns_prefix/bin/codepatterns-config; then
          codepatterns_pkgconfig=no
          CodePatterns_CONFIG="$codepatterns_prefix/bin/codepatterns-config"
          AC_MSG_RESULT([yes])
        else
          AC_MSG_RESULT([no])
        fi
      fi
    ])

  # try to set values via CodePatterns_CONFIG
  if test ! -z "$CodePatterns_CONFIG"; then 
    CodePatterns_CFLAGS=`$CodePatterns_CONFIG --cflags`
    if test x$codepatterns_pkgconfig = xno; then
      CodePatterns_LIBS=`$CodePatterns_CONFIG --ldflags --libs`
    else
      CodePatterns_LIBS=`$CodePatterns_CONFIG --libs`
    fi
    #AC_MSG_NOTICE([codepatterns-config found and used.])
  fi

  # else set by hand (or rather by --with..)
  if test x$codepatterns_include_prefix != x ; then
    if test -e $codepatterns_include_prefix/include; then
      CodePatterns_CFLAGS="$codepatterns_include_prefix/include"
      AC_MSG_NOTICE([codepatterns include found and used.])
    else
      AC_MSG_WARN([codepatterns include not found at $codepatterns_include_prefix/include.])
    fi
  fi
  if test x$cp_cv_codepatterns_libs_prefix != x ; then
    if test -e "$cp_cv_codepatterns_libs_prefix/lib/libCodePatterns.so"; then
      CodePatterns_LIBS="-L$cp_cv_codepatterns_libs_prefix/lib -lCodePatterns"
      AC_MSG_NOTICE([codepatterns libs found and used.])
    else
      AC_MSG_WARN([codepatterns libs not found at $cp_cv_codepatterns_libs_prefix.])
    fi
  fi

  codepatterns="no"
  if test "x$CodePatterns_CFLAGS" != "x"; then
    if test "x$CodePatterns_LIBS" != "x"; then
      codepatterns="yes"
    fi
  fi


  if test x$codepatterns_pkgconfig != xyes; then
    # check version of lib
    no_codepatterns=""
    codepatterns_version=no
    if test x$codepatterns = xyes; then
      AC_MSG_CHECKING(for CodePatterns - version >= $codepatterns_version_min)
      if test "x$CodePatterns_CONFIG" != "x"; then
        codepatterns_version=`$CodePatterns_CONFIG --version`
      else
        codepatterns_version=""
      fi
  
      codepatterns_major_version=`echo $codepatterns_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      codepatterns_minor_version=`echo $codepatterns_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      codepatterns_micro_version=`echo $codepatterns_version | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
  
      #AC_MSG_NOTICE([Version found is: $codepatterns_major_version.$codepatterns_minor_version.$codepatterns_micro_version])
      #AC_MSG_NOTICE([Version required is: $codepatterns_version_min])
  
      codepatterns_major_min=`echo $codepatterns_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
      if test "x${codepatterns_major_min}" = "x" ; then
         codepatterns_major_min=0
      fi
      
      codepatterns_minor_min=`echo $codepatterns_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
      if test "x${codepatterns_minor_min}" = "x" ; then
         codepatterns_minor_min=0
      fi
  
      codepatterns_micro_min=`echo $codepatterns_version_min | \
             sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
      if test "x${codepatterns_micro_min}" = "x" ; then
         codepatterns_micro_min=0
      fi
  
      if test $codepatterns_major_version -lt $codepatterns_major_min; then
        codepatterns_version_proper=0
      fi
      if test $codepatterns_major_version -gt $codepatterns_major_min; then
        codepatterns_version_proper=1
      else
        if test $codepatterns_minor_version -lt $codepatterns_minor_min; then
          codepatterns_version_proper=0
        fi
        if test $codepatterns_minor_version -gt $codepatterns_minor_min; then
          codepatterns_version_proper=1
        else
          if test $codepatterns_micro_version -ge $codepatterns_micro_min; then
            codepatterns_version_proper=1
          else 
            codepatterns_version_proper=0
          fi
        fi
      fi
      #AC_MSG_NOTICE([$codepatterns_version_proper])
      
      if test $codepatterns_version_proper = 1 ; then
        codepatterns_version=yes
        AC_MSG_RESULT([$codepatterns_major_version.$codepatterns_minor_version.$codepatterns_micro_version])
      else
        AC_MSG_RESULT(no)
        codepatterns_version=no
      fi
    fi

    # check presence of lib
    SAVE_CPPFLAGS="$CPPFLAGS"
    SAVE_LIBS="$LIBS"
    CPPFLAGS="$CodePatterns_CFLAGS"
    LIBS="$CodePatterns_LIBS -lboost_thread"
    if test x$codepatterns_version = xyes; then
      AC_CACHE_CHECK(for CodePatterns lib, cp_cv_codepatterns_lib, [
        AC_LANG_PUSH([C++])
        AC_LINK_IFELSE(
          [
            AC_LANG_PROGRAM([
#include "CodePatterns/Singleton.hpp"
#include "CodePatterns/Singleton_impl.hpp"

// some necessary stubs
class SingletonStub : public Singleton <SingletonStub>{
  friend class Singleton<SingletonStub>;
private:
  SingletonStub(){
    count1++;
  }
  // explicit copy constructor to catch if this is ever called
  SingletonStub(const SingletonStub&){}
  virtual ~SingletonStub(){
    count2++;
  }
public:
  static int count1;
  static int count2;
};

int SingletonStub::count1 = 0;
int SingletonStub::count2 = 0;

CONSTRUCT_SINGLETON(SingletonStub);

], [
SingletonStub::getInstance();
])
          ],[
            cp_cv_codepatterns_lib="yes"
          ], [
            cp_cv_codepatterns_lib="no"
          ]
        )
        AC_LANG_POP([C++])
      ])
    fi
    CPPFLAGS="$SAVE_CPPFLAGS"
    LIBS="$SAVE_LIBS"

    if test "x$cp_cv_codepatterns_lib" = xyes ; then
       ifelse([$2], , :, [$2])     
    else
       CodePatterns_CFLAGS=""
       CodePatterns_LDFLAGS=""
       CodePatterns_LIBS=""
       ifelse([$3], , :, [$3])
    fi
  fi
  
  AC_SUBST(CodePatterns_CFLAGS)
  AC_SUBST(CodePatterns_LDFLAGS)
  AC_SUBST(CodePatterns_LIBS)
])
 
