/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotMoleculeOfAtomAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeOfAtomSelectionDescriptor.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

using namespace std;

#include "NotMoleculeOfAtomAction.hpp"

// and construct the stuff
#include "NotMoleculeOfAtomAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotMoleculeOfAtomAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<molecule *> unselectedMolecules = World::getInstance().getSelectedMolecules();
  DoLog(1) && (Log() << Verbose(1) << "Unselecting molecule to currently selected atoms." << endl);
  World::getInstance().unselectAllMolecules(MoleculesByAtomSelection());
  DoLog(0) && (Log() << Verbose(0) << World::getInstance().countSelectedMolecules() << " molecules remain selected." << endl);
  return Action::state_ptr(new SelectionNotMoleculeOfAtomState(unselectedMolecules, params));
}

Action::state_ptr SelectionNotMoleculeOfAtomAction::performUndo(Action::state_ptr _state) {
  SelectionNotMoleculeOfAtomState *state = assert_cast<SelectionNotMoleculeOfAtomState*>(_state.get());

  World::getInstance().clearMoleculeSelection();
  BOOST_FOREACH(molecule *_mol, state->unselectedMolecules)
    World::getInstance().selectMolecule(_mol);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotMoleculeOfAtomAction::performRedo(Action::state_ptr _state){
  //SelectionNotMoleculeOfAtomState *state = assert_cast<SelectionNotMoleculeOfAtomState*>(_state.get());

  World::getInstance().unselectAllMolecules(MoleculesByAtomSelection());

  return Action::state_ptr(_state);
}

bool SelectionNotMoleculeOfAtomAction::canUndo() {
  return true;
}

bool SelectionNotMoleculeOfAtomAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
